#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 300000
#define PI acos(-1.0)

typedef struct {
    double ang;
    long long x, y;
    int idx;
} Vec;

Vec a[2 * MAXN];
int n;

int cmp(const void *p1, const void *p2) {
    double d = ((Vec *)p1)->ang - ((Vec *)p2)->ang;
    if (d < 0) return -1;
    if (d > 0) return 1;
    return 0;
}

int main() {
    int i;
    scanf("%d", &n);

    for (i = 0; i < n; i++) {
        long long x, y;
        scanf("%lld %lld", &x, &y);
        a[i].x = x;
        a[i].y = y;
        a[i].idx = i + 1;
        a[i].ang = atan2((double)y, (double)x);
    }

    qsort(a, n, sizeof(Vec), cmp);

    for (i = 0; i < n; i++) {
        a[i + n] = a[i];
        a[i + n].ang += 2 * PI;
    }

    {
        long long sx = 0, sy = 0;
        double best = 0;
        int bestL = 0, bestR = -1;
        int l = 0, r;

        for (r = 0; r < 2 * n; r++) {
            sx += a[r].x;
            sy += a[r].y;

            while (a[r].ang - a[l].ang >= PI) {
                sx -= a[l].x;
                sy -= a[l].y;
                l++;
            }

            if ((double)sx * sx + (double)sy * sy > best) {
                best = (double)sx * sx + (double)sy * sy;
                bestL = l;
                bestR = r;
            }
        }

        printf("%d\n", bestR - bestL + 1);
        for (i = bestL; i <= bestR; i++) {
            printf("%d ", a[i].idx);
        }
        printf("\n");
    }

    return 0;
}